/************************************************************************************************************\

Module Name:    MtxTypes.h

Description:    Matrox types.

References:     None.

    Copyright (c) 2011, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

#ifndef INC_LTYPES_H
#define INC_LTYPES_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------


/************************************************************************************************************\

Structure:      LRECT32

Description:    Liberatus style rectangle structure with 32-bits integers.

Comments:       None.

\************************************************************************************************************/
typedef struct tagLRECT32
{
    MINT32  iLeft;
    MINT32  iTop;
    MINT32  iRight;
    MINT32  iBottom;
} LRECT32;

/************************************************************************************************************\

Structure:      LPOS32

Description:    Liberatus style position structure with 32-bits integers.

Comments:       None.

\************************************************************************************************************/
typedef struct tagLPOS32
{
    MINT32  iX;
    MINT32  iY;
} LPOS32;

/************************************************************************************************************\

Structure:      LSIZE32

Description:    Liberatus style size structure with 32-bits integers.

Comments:       None.

\************************************************************************************************************/
typedef struct tagLSIZE32
{
    MINT32  iCx;
    MINT32  iCy;
} LSIZE32;

/************************************************************************************************************\
 
Structure:      LRECT
 
Description:    Liberatus style rectangle structure
 
Comments:       Please note that the members are integers.
 
\************************************************************************************************************/
typedef struct tagLRECT
{
    MINT    iLeft;
    MINT    iTop;
    MINT    iRight;
    MINT    iBottom;
} LRECT;

/************************************************************************************************************\
 
Structure:      LSIZE
 
Description:    Liberatus style size structure
 
Comments:       Please note that the members are integers.
 
\************************************************************************************************************/
typedef struct tagLSIZE
{
    MINT    iWidth;
    MINT    iHeight;
} LSIZE;

/************************************************************************************************************\
 
Structure:      LPOS
 
Description:    Liberatus style position structure
 
Comments:       Please note that the members are integers.
 
\************************************************************************************************************/
typedef struct tagLPOS
{
    MINT    iX;
    MINT    iY;
} LPOS;

/************************************************************************************************************\

Struct:         LAccessMode

Description:    Enumerates all supported handle access level.

Comments:       - LAccessMode_READWRITE or LAccessMode_READWRITE_EXCLUSIVE are require to apply change
                  on the hardware.

\************************************************************************************************************/
typedef enum
{
    LAccessMode_NONE                = 0x00000000,   // Not valid.
    LAccessMode_READONLY            = 0x00000001,   // Use to query information or test parameters.
    LAccessMode_READWRITE           = 0x00000002,   // Use to configure the hardware and operate the resource.
    LAccessMode_READWRITE_EXCLUSIVE = 0x00000003,   // Change hardware, operate resource in exclusive mode.
    LAccessMode_FORCE32             = 0x7FFFFFFF    // Dummy value to force enumeration to use 32 bits.
} LAccessMode;


/************************************************************************************************************\
 
Structure:      LSTR64
 
Description:    Liberatus 64 character string max
 
Comments:       None
 
\************************************************************************************************************/
#define L64_STRING_MAX         64
#define L256_STRING_MAX        256
#define L4096_STRING_MAX       4096

typedef MCHAR8 LSTR64[L64_STRING_MAX];
typedef MCHAR8 LSTR256[L256_STRING_MAX];
typedef MCHAR8 LSTR4096[L4096_STRING_MAX];


// -----------------------------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                         G L O B A L   F U N C T I O N   D E C L A R A T I O N S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                      I N L I N E S   A N D   T E M P L A T E   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------


#endif /* INC_LTYPES_H */
